package sampling;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Label;
import graphics.Slider;
import graphics.SliderFrame;
import misc.Debug;


/** FreqSlider extends Slider. It's not visible outside this package.
 *
 * @version 0.10 03 Nov 1996
 * @author <A HREF="http:www.th-darmstadt.de/~mkarsten">Martin Karsten</A>
 */
class FreqSlider extends Slider {
	protected BaseSampler sampler;
	protected FreqSlider( BaseSampler sampler, int min, int max, int value ) {
		SetMinimum( min );
		SetMaximum( max );
		SetValue( value );
		this.sampler = sampler;
	}
	public void finish() {
		sampler = null;
	}
	protected void finalize() {
		Debug.outa("FreqSlider.finalize: called");
		try { super.finalize(); } catch ( Throwable _x ) { ; }
	}
} // end of class FreqSlider


/** PollSlider extends FreqSlider. It's not visible outside this package.
 *
 * @version 0.10 03 Nov 1996
 * @author <A HREF="http:www.th-darmstadt.de/~mkarsten">Martin Karsten</A>
 */
class PollSlider extends FreqSlider {
	protected PollSlider( BaseSampler sampler ) {
		super( sampler, 10, 1000, sampler.pollFrequency );
	}
	protected void Motion() {
		sampler.pollFrequency = GetValue();
	}
} // end of class PollSlider


/** DisplaySlider extends FreqSlider. It's not visible outside this package.
 *
 * @version 0.10 03 Nov 1996
 * @author <A HREF="http:www.th-darmstadt.de/~mkarsten">Martin Karsten</A>
 */
class DisplaySlider extends FreqSlider {
	protected DisplaySlider( BaseSampler sampler ) {
		super( sampler, 10, 1000, sampler.displayFrequency );
	}
	protected void Motion() {
		sampler.displayFrequency = GetValue();
	}
} // end of class DisplaySlider


/**
 * A ControlSliderFrame object is the user interface for a Control object.
 * It's not visible outside the package.
 *
 * @version 0.10 03 Nov 1996
 * @author <A HREF="http:www.th-darmstadt.de/~mkarsten">Martin Karsten</A>
 */
class SamplerSliderFrame extends SliderFrame {
	SamplerSliderFrame( BaseSampler sampler ) {
		super( sampler.name, 2, 2 );
		Component component;
		component = new Label( "Poll (msec):" );
		constrain( this, component, 0, 0, 1, 1, GridBagConstraints.VERTICAL,
			GridBagConstraints.WEST, 0.0, 0.5 );
		component = new PollSlider( sampler );
		constrain( this, component, 1, 0, 1, 1, GridBagConstraints.BOTH,
			GridBagConstraints.EAST, 1.0, 0.5 );
		component = new Label( "Display (msec):");
		constrain( this, component, 0, 1, 1, 1, GridBagConstraints.VERTICAL,
			GridBagConstraints.WEST, 0.0, 0.5 );
		component = new DisplaySlider( sampler );
		constrain( this, component, 1, 1, 1, 1, GridBagConstraints.BOTH,
			GridBagConstraints.EAST, 1.0, 0.5 );
		resize( 300, 122 );
  }

	public void finish() {
		super.finish();
	}

	protected void finalize() {
		Debug.outa("SamplerSliderFrame.finalize: called");
		try { super.finalize(); } catch ( Throwable _x ) { ; }
	}
} // end of class SamplerSliderFrame
